/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.network.messages.server.colony.citizen;

import com.ldtteam.structurize.util.LanguageHandler;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.coremod.network.messages.server.AbstractBuildingServerMessage;
import com.minecolonies.coremod.util.TeleportHelper;
import java.util.Optional;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class RecallSingleCitizenMessage
extends AbstractBuildingServerMessage<IBuilding> {
    private int citizenId;

    public RecallSingleCitizenMessage() {
    }

    public RecallSingleCitizenMessage(IBuildingView building, int citizenid) {
        super(building);
        this.citizenId = citizenid;
    }

    @Override
    public void fromBytesOverride(@NotNull PacketBuffer buf) {
        this.citizenId = buf.readInt();
    }

    @Override
    public void toBytesOverride(@NotNull PacketBuffer buf) {
        buf.writeInt(this.citizenId);
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, IBuilding building) {
        ICitizenData citizenData = colony.getCitizenManager().getCivilian(this.citizenId);
        citizenData.setLastPosition(building.getPosition());
        Optional<AbstractEntityCitizen> optionalEntityCitizen = citizenData.getEntity();
        if (!optionalEntityCitizen.isPresent()) {
            citizenData.updateEntityIfNecessary();
            optionalEntityCitizen = citizenData.getEntity();
        }
        if (optionalEntityCitizen.isPresent() && optionalEntityCitizen.get().getTicksExisted() == 0) {
            citizenData.updateEntityIfNecessary();
        }
        BlockPos loc = building.getID();
        if (optionalEntityCitizen.isPresent() && !TeleportHelper.teleportCitizen(optionalEntityCitizen.get(), colony.getWorld(), loc)) {
            ServerPlayerEntity player = ctxIn.getSender();
            if (player == null) {
                return;
            }
            LanguageHandler.sendPlayerMessage((PlayerEntity)player, (String)"com.minecolonies.coremod.workerhuts.recallFail", (Object[])new Object[0]);
        }
    }
}

